/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hwmca.fw.servlet.pmod.util;

import com.ibm.hwmca.fw.servlet.pmod.ModelContentHandler;
import com.ibm.hwmca.fw.servlet.pmod.ModelContentTCFException;
import com.ibm.hwmca.fw.servlet.pmod.PanelModel;
import com.ibm.hwmca.fw.servlet.pmod.PanelModelException;
import com.ibm.hwmca.fw.util.Trace;
import java.util.Properties;

public class TracingHandler
implements ModelContentHandler {
    private static final String TRACE_MASKF = "XPMUTRCF";
    private static final String TRACE_MASKT = "XPMUTRCT";
    private static final String TRACE_MASKD = "XPMUTRCD";
    public static final String BLANKS = "                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                     ";
    private static String[] BLANKSTRING_CACHE = new String[75];
    private static final int BLANKS_LENGTH = "                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                     ".length() - 1;
    private ModelContentHandler handler;
    private int depth = 0;
    private boolean toTrace = true;

    public TracingHandler(ModelContentHandler handler) {
        this(handler, true);
    }

    public TracingHandler(ModelContentHandler handler, boolean toTrace) {
        this.handler = handler;
        this.toTrace = toTrace;
    }

    public void catchElement(String tagPrefix, String tagName, ModelContentTCFException exception) throws PanelModelException {
        if (this.toTrace) {
            Trace.trace(TRACE_MASKF, PanelModel.getTraceArgSB().append("[C-ele]").append(TracingHandler.indent(this.depth)).append(this.formFullName(tagPrefix, tagName)).append(exception));
        } else {
            System.out.println("[C-ele]" + TracingHandler.indent(this.depth) + this.formFullName(tagPrefix, tagName) + exception);
        }
        this.handler.catchElement(tagPrefix, tagName, exception);
    }

    public void startDocument() throws PanelModelException {
        if (this.toTrace) {
            Trace.trace(TRACE_MASKF, "TracingHandler begins (startDocument()) Note, pure whitespace [chars] invocations are suppressed!");
        } else {
            System.out.println("TracingHandler begins (startDocument()) Note, pure whitespace [chars] invocations are suppressed!");
        }
        this.handler.startDocument();
    }

    public int startElement(String tagPrefix, String tagName, Properties attributes, boolean isBodyEmpty) throws PanelModelException {
        ++this.depth;
        String attributeDump = "";
        if (!attributes.isEmpty()) {
            attributeDump = attributes.toString();
        }
        if (this.toTrace) {
            Trace.trace(TRACE_MASKF, PanelModel.getTraceArgSB().append("[s-ele]").append(TracingHandler.indent(this.depth)).append(this.formFullName(tagPrefix, tagName)).append(attributeDump));
        } else {
            System.out.println("[s-ele]" + TracingHandler.indent(this.depth) + this.formFullName(tagPrefix, tagName) + attributeDump);
        }
        return this.handler.startElement(tagPrefix, tagName, attributes, isBodyEmpty);
    }

    private String formFullName(String pre, String name) {
        String fullName = name;
        if (pre != null && !"".equals(pre)) {
            fullName = pre + ":" + fullName;
        }
        return "<" + fullName + ">";
    }

    public static String indent(int theDepth) {
        if ((theDepth = Math.max(0, theDepth)) < BLANKSTRING_CACHE.length - 1) {
            if (BLANKSTRING_CACHE[theDepth] == null) {
                TracingHandler.BLANKSTRING_CACHE[theDepth] = BLANKS.substring(0, Math.min(Math.max(theDepth, 0), BLANKS_LENGTH));
            }
            return BLANKSTRING_CACHE[theDepth];
        }
        return BLANKS.substring(0, Math.min(Math.max(theDepth, 0), BLANKS_LENGTH));
    }

    public int endElement(String tagPrefix, String tagName) throws PanelModelException {
        if (this.toTrace) {
            Trace.trace(TRACE_MASKF, PanelModel.getTraceArgSB().append("[e-ele]").append(TracingHandler.indent(this.depth)).append(this.formFullName(tagPrefix, tagName)));
        } else {
            System.out.println("[e-ele]" + TracingHandler.indent(this.depth) + this.formFullName(tagPrefix, tagName));
        }
        --this.depth;
        return this.handler.endElement(tagPrefix, tagName);
    }

    public void endDocument() throws PanelModelException {
        if (this.toTrace) {
            Trace.trace(TRACE_MASKF, "TracingHandler ends (endDocument())");
        } else {
            System.out.println("TracingHandler ends (endDocument())");
        }
        this.handler.endDocument();
    }

    public void characters(char[] ch, int start, int length) throws PanelModelException {
        int end = start + length;
        boolean justWhite = true;
        block3: for (int i = start; i < end && justWhite; ++i) {
            char theCh = ch[i];
            switch (theCh) {
                case '\t': 
                case '\n': 
                case '\f': 
                case '\r': 
                case ' ': {
                    continue block3;
                }
                default: {
                    justWhite = false;
                }
            }
        }
        if (!justWhite) {
            if (this.toTrace) {
                Trace.trace(TRACE_MASKF, PanelModel.getTraceArgSB().append("[chars]").append(TracingHandler.indent(this.depth)).append(ch, start, length));
            } else {
                System.out.println("[chars]" + TracingHandler.indent(this.depth) + new String(ch, start, length));
            }
        }
        this.handler.characters(ch, start, length);
    }

    public void jspELExpression(char[] ch, int start, int length) throws PanelModelException {
        if (this.toTrace) {
            Trace.trace(TRACE_MASKF, PanelModel.getTraceArgSB().append("[jsp-e]").append(TracingHandler.indent(this.depth)).append(ch, start, length));
        } else {
            System.out.println("[jsp-e]" + TracingHandler.indent(this.depth) + new String(ch, start, length));
        }
        this.handler.jspELExpression(ch, start, length);
    }

    public void jspDirective(char[] ch, int start, int length) throws PanelModelException {
        if (this.toTrace) {
            Trace.trace(TRACE_MASKF, PanelModel.getTraceArgSB().append("[jsp-d]").append(TracingHandler.indent(this.depth)).append(ch, start, length));
        } else {
            System.out.println("[jsp-d]" + TracingHandler.indent(this.depth) + new String(ch, start, length));
        }
        this.handler.jspDirective(ch, start, length);
    }

    public void startIgnoredConstruct(String prefix) throws PanelModelException {
        if (this.toTrace) {
            Trace.trace(TRACE_MASKF, PanelModel.getTraceArgSB().append("[s-ign]").append(TracingHandler.indent(this.depth)).append(prefix));
        } else {
            System.out.println("[s-ign]" + TracingHandler.indent(this.depth) + prefix);
        }
        this.handler.startIgnoredConstruct(prefix);
    }

    public void endIgnoredConstruct(String suffix) throws PanelModelException {
        if (this.toTrace) {
            Trace.trace(TRACE_MASKF, PanelModel.getTraceArgSB().append("[e-ign]").append(TracingHandler.indent(this.depth)).append(suffix));
        } else {
            System.out.println("[e-ign]" + TracingHandler.indent(this.depth) + suffix);
        }
        this.handler.endIgnoredConstruct(suffix);
    }

    public void error(PanelModelException e, String location) {
        if (this.toTrace) {
            Trace.trace(TRACE_MASKT, PanelModel.getTraceArgSB().append("TracingHandler error() invocation location=").append(location));
            Trace.trace(TRACE_MASKT, e);
        } else {
            System.out.println("TracingHandler error() invocation location=" + location);
            e.printStackTrace();
        }
        this.handler.error(e, location);
    }
}

